#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Outfile=rundo.exe
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
; AutoIt v3 script to run a Stata do-file from an external text editor
; Version 4.0, 14 August 2011
; Friedrich Huebler, fhuebler@gmail.com, www.huebler.info
; Modification by JSL de Munter, supply all information through commandline rather than .ini. to automate even furter
; advantage includes to just update commandline when new Stata version gets released.
Opt("TrayIconDebug", 0)
; command line parameters
; $CmdLine[1] Path do current Do file
; $CmdLine[2] 0/1 Run the whole Do file? Or only selection (this combines the rundo.au3 and rundolines.au3 from Friedrich Huebler in 1 .exe)
; $CmdLine[3] String Name of Stata window
; $CmdLine[4] String Path of Stata executable
; $CmdLine[5] String Keyboard shortcut for Stata command window
; $CmdLine[6] String Name of text editor window
; $CmdLine[7] 0/1 Should we go back to text editor window after completing the action? yes/no
; $CmdLine[8] Should we restore the clipboard? yes/no

; Declare variables
Global $statapath, $statawin, $back2edit, $edit, $statacmd, $dofile, $clippause, $winpause, $keypause

If $CMDLINE[0] = 8 Then
; Path to do-file that is passed to AutoIt
$dofile = $CmdLine[1]

; Run the whole Do file? Otherwise rundolines
$rundo = $CmdLine[2]

; Name of Stata window
$statawin = $CmdLine[3]

; Path to Stata executable
$statapath = $CmdLine[4]

; Keyboard shortcut to Stata command window
$statacmd = $CmdLine[5]

; Name of text editor window
$edit = $CmdLine[6]

; Should we go back to text editor window
$back2edit = $CmdLine[7]

; Should we restore the clipboard?
$putclipback = $CmdLine[8]
Else
   MsgBox(0, "Error", "You did not specify the 8 necessary command line parameters")
   Exit
EndIf

; Delays
; Pause after copying of Stata commands to clipboard
$clippause = "100"
; Pause between window-related operations
$winpause = "500"
; Pause between keystrokes sent to Stata
$keypause = "1"

; Set WinWaitDelay and SendKeyDelay to speed up or slow down script
Opt("WinWaitDelay", $winpause)
Opt("SendKeyDelay", $keypause)

; If more than one Stata window is open, the window that was most recently active will be matched
Opt("WinTitleMatchMode", 2)

; Let's not loose the information that is currently in the clipboard:
$commands = ClipGet()
; Create file name in system temporary directory
$tempf = EnvGet("TEMP") & "\clipboard.tmp"
; Open file for writing and check that it worked
$tempf2 = FileOpen($tempf, 2)

If $tempf2 = -1 Then
   MsgBox(0, "Error: Cannot open temporary file", "at [" & $tempf & "]")
   Exit
EndIf

; Write clipboard to temporary file
FileWrite($tempf2, $commands)
FileClose($tempf2)
; End of putting current information in clipboard

If $rundo = 1 Then
  ; Check if Stata is already open, start Stata if not
  If WinExists($statawin) Then
    WinActivate($statawin)
    WinWaitActive($statawin)
    ; Activate Stata command window and select text (if any)
    Send($statacmd)
    Send("^a")
    ; Run saved do-file
    ; Double quotes around $dofile needed in case path contains blanks
    ClipPut("do " & '"' & $dofile & '"')
    ; Pause avoids problem with clipboard, may be AutoIt or Windows bug
    Sleep($clippause)
    Send("^v" & "{Enter}")
  Else
    Run($statapath)
    WinWaitActive($statawin)
    ; Activate Stata command window
    Send($statacmd)
    ; Run saved do-file
    ; Double quotes around $dofile needed in case path contains blanks
    ClipPut("do " & '"' & $dofile & '"')
    ; Pause avoids problem with clipboard, may be AutoIt or Windows bug
    Sleep($clippause)
    Send("^v" & "{Enter}")
  EndIf
Else
  ; Clear clipboard
  ClipPut("")
  ; Copy selected lines from editor to clipboard
  Send("^c")
  ; Pause avoids problem with clipboard, may be AutoIt or Windows bug
  Sleep($clippause)
  $commands = ClipGet()

  ; Terminate script if no commands selected in editor
  If $commands = "" Then
    Exit
  EndIf

  ; Create file name in system temporary directory
  $tempfile = EnvGet("TEMP") & "\statacmd.tmp"

  ; Open file for writing and check that it worked
  $tempfile2 = FileOpen($tempfile, 2)
  If $tempfile2 = -1 Then
    MsgBox(0, "Error: Cannot open temporary file", "at [" & $tempfile & "]")
    Exit
  EndIf

  ; Write commands to temporary file, add CR-LF at end to ensure last line is executed by Stata
  FileWrite($tempfile2, $commands & @CRLF)
  FileClose($tempfile2)

  ; Check if Stata is already open, start Stata if not
  If WinExists($statawin) Then
    WinActivate($statawin)
    WinWaitActive($statawin)
    ; Activate Stata command window and select text (if any)
    Send($statacmd)
    Send("^a")
    ; Run temporary file
    ; Double quotes around $tempfile needed in case path contains blanks
    ClipPut("do " & '"' & $tempfile & '"')
    ; Pause avoids problem with clipboard, may be AutoIt or Windows bug
    Sleep($clippause)
    Send("^v" & "{Enter}")
    Sleep($clippause)
  Else
    Run($statapath)
    WinWaitActive($statawin)
    ; Activate Stata command window
    Send($statacmd)
    ; Run temporary file
    ; Double quotes around $dofile needed in case path contains blanks
    ClipPut("do " & '"' & $tempfile & '"')
    ; Pause avoids problem with clipboard, may be AutoIt or Windows bug
    Sleep($clippause)
    Send("^v" & "{Enter}")
    Sleep($clippause)
  Send("{CTRLUP}")
  EndIf

EndIf

; Activate editor window
If $back2edit = "1" Then
   If WinExists($edit) Then
     WinActivate($edit)
     WinWaitActive($edit)
     ClipPut("")
     ClipPut(Send("^c"))
  Else
	 MsgBox(0,"ERROR", "Window " & $edit & " not found!")
	 Exit
  EndIf
EndIf

;put the old stuff back into the clipboard
If $putclipback = "1" Then
  $tempf2 = FileRead($tempf)
  ClipPut($tempf2)
EndIf
; End of script

; Prevent a stuck CTRL key in pressed mode after running the script.
Sleep(10)
Send("{CTRLDOWN}")
Sleep(10)
Send("{CTRLUP}")

; MsgBox(0, "Done", "The script has finished!")
Exit