/* Use this if this is not the first time you are  using this sample. 
Uncomment the next line. Oh, BTW this is a multiline comment! */
--DROP TABLE news_abc;

CREATE TABLE news_abc(start_date DATE NOT NULL, end_date DATE NOT NULL, text VARCHAR2(50));

INSERT INTO news_abc(start_date, end_date, text) VALUES(SYSDATE, SYSDATE+10, 'This is a test news!');
INSERT INTO news_abc(start_date, end_date, text) VALUES(SYSDATE+2, SYSDATE+12, 'Future News!');
INSERT INTO news_abc(start_date, end_date, text) VALUES(SYSDATE-3, SYSDATE+4, 'Newsflash!');
INSERT INTO news_abc(start_date, end_date, text) VALUES(SYSDATE-10, SYSDATE-4, 'Old news :-(');

SELECT * FROM news_abc;

SET SERVEROUTPUT ON
DECLARE
    CURSOR c_news IS
        SELECT * 
        FROM news_abc
        WHERE SYSDATE BETWEEN start_date AND end_date;
BEGIN
    FOR r_news IN c_news LOOP
        dbms_output.put_line(r_news.text);
    END LOOP;
END;
/
